/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hwmca.base.rsf.util;

import com.ibm.hwmca.base.rsf.BaseRsfErrorIds;
import com.ibm.hwmca.fw.HException;
import com.ibm.hwmca.fw.log.FrameworkClassLogInfo;
import com.ibm.hwmca.fw.log.FrameworkLog;
import com.ibm.hwmca.fw.util.FileControl;
import com.ibm.hwmca.fw.util.Trace;
import java.io.File;
import java.util.ArrayList;

public class RsfFileControl
extends FileControl
implements BaseRsfErrorIds {
    protected static ArrayList _dfcMask = new ArrayList();
    protected static ArrayList _dfcPath = new ArrayList();
    private static boolean _dfcTableRead = false;
    private static boolean _dfcDefPathFound = false;
    private static String _dfcDefPath;
    private static String _dfcDefFileName;
    private static String _dfcDefFile;
    private static FrameworkClassLogInfo _logInfo;
    private static final String TRACE_MASKT = "XRSFDFCT";
    private static final String TRACE_MASKD = "XRSFDFCD";
    private static final String TRACE_MASKF = "XRSFDFCF";

    public static String getFilePath(String fn) throws HException {
        Trace.trace(TRACE_MASKT, "-> RsfFileControl.getFilePath() - " + fn);
        String filePath = "";
        if (!_dfcTableRead) {
            if (!_dfcDefPathFound) {
                String msg = "Initialization error - CONSOLE_PATH was null.";
                Trace.trace(TRACE_MASKF, "   RsfFileControl.getFilePath():" + msg);
                HException hexc = new HException(msg);
                new FrameworkLog(_logInfo, 1, hexc).log();
                throw hexc;
            }
            String msg = "Initialization error - Definition file was not read.";
            Trace.trace(TRACE_MASKF, "   RsfFileControl.getFilePath():" + msg);
            HException hexc = new HException(msg);
            throw hexc;
        }
        filePath = FileControl.getFilePath(_dfcDefFile, fn, _dfcMask, _dfcPath);
        Trace.trace(TRACE_MASKT, "<- RsfFileControl.getFilePath() - " + filePath);
        return filePath;
    }

    public static void makeFilePath(String fn) throws HException {
        Trace.trace(TRACE_MASKT, "-> RsfFileControl.makeFilePath()");
        String filePath = RsfFileControl.getFilePath(fn);
        File thePath = new File(filePath);
        thePath.mkdirs();
        Trace.trace(TRACE_MASKT, "<- RsfFileControl.makeFilePath()");
    }

    static {
        _dfcDefFileName = "RsfFileControl.trm";
        _dfcDefFile = "";
        _logInfo = new FrameworkClassLogInfo(-44, "RsfFileCntl");
        try {
            String consolePath = System.getProperty("CONSOLE_PATH");
            Trace.trace(TRACE_MASKF, "   RsfFileControl(): CONSOLE_PATH = \"" + consolePath + "\"");
            if (consolePath != null) {
                _dfcDefPathFound = true;
                _dfcDefPath = consolePath + "data/";
                _dfcDefFile = _dfcDefPath + _dfcDefFileName;
                Trace.trace(TRACE_MASKF, "   RsfFileControl(): Definition file = " + _dfcDefFile);
                FileControl.readDefFile(_dfcDefFile, _dfcMask, _dfcPath);
                _dfcTableRead = true;
            }
        }
        catch (Throwable _exc) {
            Trace.trace(TRACE_MASKF, "   RsfFileControl(): Error trying to read/process the definition file: " + _dfcDefFile);
        }
    }
}

